/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.appspace.VWAppSpaceFilteredSecurityPanel;
import filenet.vw.toolkit.admin.property.appspace.VWAppSpaceSecurityPanel;
import filenet.vw.toolkit.admin.property.appspace.VWRolesPanel;
import filenet.vw.toolkit.admin.property.base.VWConfigGeneralPane;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VWAppSpacePropertyDialog
extends VWModalDialog
implements ActionListener {
    private JTabbedPane m_tabbedPanel = null;
    private VWConfigGeneralPane m_generalPanel = null;
    private VWAppSpaceSecurityPanel m_securityPanel = null;
    private VWRolesPanel m_rolePanel = null;
    private JButton m_OKButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWSessionInfo m_sessionInfo = null;
    private VWApplicationSpaceDefinition m_appSpaceDef = null;

    public VWAppSpacePropertyDialog(VWSessionInfo sessionInfo, VWSystemConfiguration sysConfig, VWApplicationSpaceDefinition appSpaceDef) {
        super(sessionInfo.getParentFrame());
        this.m_sessionInfo = sessionInfo;
        this.m_appSpaceDef = appSpaceDef;
        this.createControls(sysConfig);
        this.setLocationRelativeTo(sessionInfo.getParentFrame());
    }

    public boolean isModified() {
        return this.m_generalPanel.isModified() || this.m_securityPanel.isModified() || this.m_rolePanel.isModified();
    }

    public String[] getModifiedQueueNames() {
        if (this.m_rolePanel != null) {
            return this.m_rolePanel.getModifiedQueueNames();
        }
        return null;
    }

    public void releaseResources() {
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.removeAll();
            this.m_tabbedPanel = null;
        }
        if (this.m_generalPanel != null) {
            this.m_generalPanel.releaseResources();
            this.m_generalPanel = null;
        }
        if (this.m_securityPanel != null) {
            this.m_securityPanel.releaseResources();
            this.m_securityPanel = null;
        }
        if (this.m_rolePanel != null) {
            this.m_rolePanel.releaseResources();
            this.m_rolePanel = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_nExitStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_OKButton) {
            try {
                this.stopEditing();
                if (this.m_generalPanel.isModified()) {
                    this.m_appSpaceDef.setDescription(this.m_generalPanel.getDescription());
                }
                if (this.m_securityPanel.validateAccessList()) {
                    VWParticipant[] writeSecList = this.m_securityPanel.getWriteSecurityPx();
                    this.m_appSpaceDef.setWriteSecurityPx(writeSecList);
                    this.m_nExitStatus = 0;
                    this.setVisible(false);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parent, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc054.htm");
        }
    }

    private void createControls(VWSystemConfiguration sysConfig) {
        try {
            this.setTitle(VWResource.ApplicationSpaceProperties);
            this.getContentPane().setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension("965,495");
            if (dim == null) {
                dim = new Dimension(650, 450);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.m_tabbedPanel = new JTabbedPane();
            VWAccessibilityHelper.setAccessibility(this.m_tabbedPanel, this, VWResource.ApplicationSpacePropertiesTabbedPane, VWResource.ApplicationSpacePropertiesTabbedPane);
            this.m_generalPanel = new VWConfigGeneralPane(this.m_appSpaceDef.getName(), VWResource.ApplicationSpace, null, -1, this.m_appSpaceDef.getDescription());
            this.m_tabbedPanel.add(VWResource.General, this.m_generalPanel);
            this.m_securityPanel = this.m_sessionInfo.getSession().getSecurityDatabaseType() == 1 ? new VWAppSpaceFilteredSecurityPanel(this, this.m_sessionInfo, this.m_appSpaceDef) : new VWAppSpaceSecurityPanel(this, this.m_sessionInfo, this.m_appSpaceDef);
            this.m_tabbedPanel.add(VWResource.Security, this.m_securityPanel);
            VWAccessibilityHelper.setAccessibility(this.m_securityPanel, this.m_tabbedPanel, VWResource.Security, VWResource.Security);
            this.m_rolePanel = new VWRolesPanel(this.m_sessionInfo, new VWDataDictionary(this.m_sessionInfo, sysConfig));
            this.m_rolePanel.setApplicationSpace(this.m_appSpaceDef);
            this.m_tabbedPanel.add(VWResource.Roles, this.m_rolePanel);
            this.m_tabbedPanel.setSelectedIndex(0);
            this.getContentPane().add((Component)this.m_tabbedPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            this.m_OKButton = new JButton(VWResource.OK);
            this.m_OKButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, this, VWResource.OK, VWResource.OK);
            buttonPanel.add(this.m_OKButton);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.Cancel, VWResource.Cancel);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.Help, VWResource.Help);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void stopEditing() {
        if (this.m_rolePanel != null) {
            this.m_rolePanel.stopEditing();
        }
    }
}

